package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WithdrawByoipCidrResponse(
    byoipCidr: Option[zio.aws.ec2.model.ByoipCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse = {
    import WithdrawByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly =
    zio.aws.ec2.model.WithdrawByoipCidrResponse.wrap(buildAwsValue())
}
object WithdrawByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.WithdrawByoipCidrResponse =
      zio.aws.ec2.model
        .WithdrawByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Option[zio.aws.ec2.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
      AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse
  ) extends zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly {
    override val byoipCidr: Option[zio.aws.ec2.model.ByoipCidr.ReadOnly] = scala
      .Option(impl.byoipCidr())
      .map(value => zio.aws.ec2.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse
  ): zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly = new Wrapper(impl)
}
