package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Vpc(
    cidrBlock: Option[String] = None,
    dhcpOptionsId: Option[String] = None,
    state: Option[zio.aws.ec2.model.VpcState] = None,
    vpcId: Option[String] = None,
    ownerId: Option[String] = None,
    instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = None,
    ipv6CidrBlockAssociationSet: Option[
      Iterable[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation]
    ] = None,
    cidrBlockAssociationSet: Option[
      Iterable[zio.aws.ec2.model.VpcCidrBlockAssociation]
    ] = None,
    isDefault: Option[Boolean] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Vpc = {
    import Vpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Vpc
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(dhcpOptionsId.map(value => value: java.lang.String))(
        _.dhcpOptionsId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .optionallyWith(
        cidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockAssociationSet)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Vpc.ReadOnly =
    zio.aws.ec2.model.Vpc.wrap(buildAwsValue())
}
object Vpc {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Vpc] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Vpc = zio.aws.ec2.model.Vpc(
      cidrBlock.map(value => value),
      dhcpOptionsId.map(value => value),
      state.map(value => value),
      vpcId.map(value => value),
      ownerId.map(value => value),
      instanceTenancy.map(value => value),
      ipv6CidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isDefault.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def cidrBlock: Option[String]
    def dhcpOptionsId: Option[String]
    def state: Option[zio.aws.ec2.model.VpcState]
    def vpcId: Option[String]
    def ownerId: Option[String]
    def instanceTenancy: Option[zio.aws.ec2.model.Tenancy]
    def ipv6CidrBlockAssociationSet
        : Option[List[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]]
    def cidrBlockAssociationSet
        : Option[List[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]]
    def isDefault: Option[Boolean]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getDhcpOptionsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dhcpOptionsId", dhcpOptionsId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpcState] =
      AwsError.unwrapOptionField("state", state)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
    def getCidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cidrBlockAssociationSet",
      cidrBlockAssociationSet
    )
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Vpc
  ) extends zio.aws.ec2.model.Vpc.ReadOnly {
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val dhcpOptionsId: Option[String] =
      scala.Option(impl.dhcpOptionsId()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.VpcState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.VpcState.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val instanceTenancy: Option[zio.aws.ec2.model.Tenancy] = scala
      .Option(impl.instanceTenancy())
      .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val ipv6CidrBlockAssociationSet
        : Option[List[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]] =
      scala
        .Option(impl.ipv6CidrBlockAssociationSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.wrap(item)
          }.toList
        )
    override val cidrBlockAssociationSet
        : Option[List[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]] =
      scala
        .Option(impl.cidrBlockAssociationSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(item)
          }.toList
        )
    override val isDefault: Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Vpc
  ): zio.aws.ec2.model.Vpc.ReadOnly = new Wrapper(impl)
}
