package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayRouteType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType
}
object TransitGatewayRouteType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType
  ): zio.aws.ec2.model.TransitGatewayRouteType = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.STATIC =>
      val r = static
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.PROPAGATED =>
      val r = propagated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.UNKNOWN_TO_SDK_VERSION
  }
  case object static extends zio.aws.ec2.model.TransitGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.STATIC
  }
  case object propagated extends zio.aws.ec2.model.TransitGatewayRouteType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType =
      software.amazon.awssdk.services.ec2.model.TransitGatewayRouteType.PROPAGATED
  }
}
