package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.ec2.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Status
  ): zio.aws.ec2.model.Status = value match {
    case software.amazon.awssdk.services.ec2.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Status.MOVE_IN_PROGRESS =>
      val r = MoveInProgress
      r
    case software.amazon.awssdk.services.ec2.model.Status.IN_VPC =>
      val r = InVpc
      r
    case software.amazon.awssdk.services.ec2.model.Status.IN_CLASSIC =>
      val r = InClassic
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Status {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Status =
      software.amazon.awssdk.services.ec2.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object MoveInProgress extends zio.aws.ec2.model.Status {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Status =
      software.amazon.awssdk.services.ec2.model.Status.MOVE_IN_PROGRESS
  }
  case object InVpc extends zio.aws.ec2.model.Status {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Status =
      software.amazon.awssdk.services.ec2.model.Status.IN_VPC
  }
  case object InClassic extends zio.aws.ec2.model.Status {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Status =
      software.amazon.awssdk.services.ec2.model.Status.IN_CLASSIC
  }
}
