package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PrefixListResourceId,
  Integer,
  SecurityGroupId,
  SecurityGroupRuleId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroupRule(
    securityGroupRuleId: Option[SecurityGroupRuleId] = None,
    groupId: Option[SecurityGroupId] = None,
    groupOwnerId: Option[String] = None,
    isEgress: Option[Boolean] = None,
    ipProtocol: Option[String] = None,
    fromPort: Option[Integer] = None,
    toPort: Option[Integer] = None,
    cidrIpv4: Option[String] = None,
    cidrIpv6: Option[String] = None,
    prefixListId: Option[PrefixListResourceId] = None,
    referencedGroupInfo: Option[zio.aws.ec2.model.ReferencedSecurityGroup] =
      None,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRule = {
    import SecurityGroupRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRule
      .builder()
      .optionallyWith(
        securityGroupRuleId.map(value =>
          SecurityGroupRuleId.unwrap(value): java.lang.String
        )
      )(_.securityGroupRuleId)
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(groupOwnerId.map(value => value: java.lang.String))(
        _.groupOwnerId
      )
      .optionallyWith(isEgress.map(value => value: java.lang.Boolean))(
        _.isEgress
      )
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(cidrIpv4.map(value => value: java.lang.String))(
        _.cidrIpv4
      )
      .optionallyWith(cidrIpv6.map(value => value: java.lang.String))(
        _.cidrIpv6
      )
      .optionallyWith(
        prefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.prefixListId)
      .optionallyWith(referencedGroupInfo.map(value => value.buildAwsValue()))(
        _.referencedGroupInfo
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRule.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRule.wrap(buildAwsValue())
}
object SecurityGroupRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRule =
      zio.aws.ec2.model.SecurityGroupRule(
        securityGroupRuleId.map(value => value),
        groupId.map(value => value),
        groupOwnerId.map(value => value),
        isEgress.map(value => value),
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        cidrIpv4.map(value => value),
        cidrIpv6.map(value => value),
        prefixListId.map(value => value),
        referencedGroupInfo.map(value => value.asEditable),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def securityGroupRuleId: Option[SecurityGroupRuleId]
    def groupId: Option[SecurityGroupId]
    def groupOwnerId: Option[String]
    def isEgress: Option[Boolean]
    def ipProtocol: Option[String]
    def fromPort: Option[Integer]
    def toPort: Option[Integer]
    def cidrIpv4: Option[String]
    def cidrIpv6: Option[String]
    def prefixListId: Option[PrefixListResourceId]
    def referencedGroupInfo
        : Option[zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly]
    def description: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getSecurityGroupRuleId: ZIO[Any, AwsError, SecurityGroupRuleId] =
      AwsError.unwrapOptionField("securityGroupRuleId", securityGroupRuleId)
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupOwnerId", groupOwnerId)
    def getIsEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEgress", isEgress)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getCidrIpv4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv4", cidrIpv4)
    def getCidrIpv6: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIpv6", cidrIpv6)
    def getPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getReferencedGroupInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("referencedGroupInfo", referencedGroupInfo)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ) extends zio.aws.ec2.model.SecurityGroupRule.ReadOnly {
    override val securityGroupRuleId: Option[SecurityGroupRuleId] = scala
      .Option(impl.securityGroupRuleId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupRuleId(value))
    override val groupId: Option[SecurityGroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupOwnerId: Option[String] =
      scala.Option(impl.groupOwnerId()).map(value => value: String)
    override val isEgress: Option[Boolean] =
      scala.Option(impl.isEgress()).map(value => value: Boolean)
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val cidrIpv4: Option[String] =
      scala.Option(impl.cidrIpv4()).map(value => value: String)
    override val cidrIpv6: Option[String] =
      scala.Option(impl.cidrIpv6()).map(value => value: String)
    override val prefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val referencedGroupInfo
        : Option[zio.aws.ec2.model.ReferencedSecurityGroup.ReadOnly] = scala
      .Option(impl.referencedGroupInfo())
      .map(value => zio.aws.ec2.model.ReferencedSecurityGroup.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRule
  ): zio.aws.ec2.model.SecurityGroupRule.ReadOnly = new Wrapper(impl)
}
