package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesIamInstanceProfile(
    arn: Option[String] = None,
    name: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile = {
    import ScheduledInstancesIamInstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.wrap(buildAwsValue())
}
object ScheduledInstancesIamInstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile =
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Option[String]
    def name: Option[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile
  ) extends zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile
  ): zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly =
    new Wrapper(impl)
}
