package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetAddressAttributeRequest(
    allocationId: AllocationId,
    attribute: zio.aws.ec2.model.AddressAttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest = {
    import ResetAddressAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .attribute(attribute.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetAddressAttributeRequest.wrap(buildAwsValue())
}
object ResetAddressAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetAddressAttributeRequest =
      zio.aws.ec2.model.ResetAddressAttributeRequest(allocationId, attribute)
    def allocationId: AllocationId
    def attribute: zio.aws.ec2.model.AddressAttributeName
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.AddressAttributeName] =
      ZIO.succeed(attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ) extends zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
    override val attribute: zio.aws.ec2.model.AddressAttributeName =
      zio.aws.ec2.model.AddressAttributeName.wrap(impl.attribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest
  ): zio.aws.ec2.model.ResetAddressAttributeRequest.ReadOnly = new Wrapper(impl)
}
