package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolEc2Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionPublicIpv4PoolCidrResponse(
    poolId: Option[Ipv4PoolEc2Id] = None,
    poolAddressRange: Option[zio.aws.ec2.model.PublicIpv4PoolRange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse = {
    import ProvisionPublicIpv4PoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse
      .builder()
      .optionallyWith(
        poolId.map(value => Ipv4PoolEc2Id.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(poolAddressRange.map(value => value.buildAwsValue()))(
        _.poolAddressRange
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.wrap(buildAwsValue())
}
object ProvisionPublicIpv4PoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse =
      zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse(
        poolId.map(value => value),
        poolAddressRange.map(value => value.asEditable)
      )
    def poolId: Option[Ipv4PoolEc2Id]
    def poolAddressRange: Option[zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly]
    def getPoolId: ZIO[Any, AwsError, Ipv4PoolEc2Id] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getPoolAddressRange
        : ZIO[Any, AwsError, zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly] =
      AwsError.unwrapOptionField("poolAddressRange", poolAddressRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse
  ) extends zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly {
    override val poolId: Option[Ipv4PoolEc2Id] = scala
      .Option(impl.poolId())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(value))
    override val poolAddressRange
        : Option[zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly] = scala
      .Option(impl.poolAddressRange())
      .map(value => zio.aws.ec2.model.PublicIpv4PoolRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse
  ): zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly =
    new Wrapper(impl)
}
