package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyInstanceMetadataOptionsRequest(
    instanceId: InstanceId,
    httpTokens: Option[zio.aws.ec2.model.HttpTokensState] = None,
    httpPutResponseHopLimit: Option[Integer] = None,
    httpEndpoint: Option[zio.aws.ec2.model.InstanceMetadataEndpointState] =
      None,
    httpProtocolIpv6: Option[zio.aws.ec2.model.InstanceMetadataProtocolState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest = {
    import ModifyInstanceMetadataOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest.wrap(buildAwsValue())
}
object ModifyInstanceMetadataOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest =
      zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest(
        instanceId,
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value)
      )
    def instanceId: InstanceId
    def httpTokens: Option[zio.aws.ec2.model.HttpTokensState]
    def httpPutResponseHopLimit: Option[Integer]
    def httpEndpoint: Option[zio.aws.ec2.model.InstanceMetadataEndpointState]
    def httpProtocolIpv6
        : Option[zio.aws.ec2.model.InstanceMetadataProtocolState]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getHttpTokens: ZIO[Any, AwsError, zio.aws.ec2.model.HttpTokensState] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataEndpointState] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataProtocolState] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest
  ) extends zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val httpTokens: Option[zio.aws.ec2.model.HttpTokensState] = scala
      .Option(impl.httpTokens())
      .map(value => zio.aws.ec2.model.HttpTokensState.wrap(value))
    override val httpPutResponseHopLimit: Option[Integer] = scala
      .Option(impl.httpPutResponseHopLimit())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val httpEndpoint
        : Option[zio.aws.ec2.model.InstanceMetadataEndpointState] = scala
      .Option(impl.httpEndpoint())
      .map(value => zio.aws.ec2.model.InstanceMetadataEndpointState.wrap(value))
    override val httpProtocolIpv6
        : Option[zio.aws.ec2.model.InstanceMetadataProtocolState] = scala
      .Option(impl.httpProtocolIpv6())
      .map(value => zio.aws.ec2.model.InstanceMetadataProtocolState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest
  ): zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
