package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyImageAttributeRequest(
    attribute: Option[String] = None,
    description: Option[zio.aws.ec2.model.AttributeValue] = None,
    imageId: ImageId,
    launchPermission: Option[zio.aws.ec2.model.LaunchPermissionModifications] =
      None,
    operationType: Option[zio.aws.ec2.model.OperationType] = None,
    productCodes: Option[Iterable[String]] = None,
    userGroups: Option[Iterable[String]] = None,
    userIds: Option[Iterable[String]] = None,
    value: Option[String] = None,
    organizationArns: Option[Iterable[String]] = None,
    organizationalUnitArns: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest = {
    import ModifyImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
      .builder()
      .optionallyWith(attribute.map(value => value: java.lang.String))(
        _.attribute
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(launchPermission.map(value => value.buildAwsValue()))(
        _.launchPermission
      )
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        organizationArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationArns)
      .optionallyWith(
        organizationalUnitArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitArns)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyImageAttributeRequest.wrap(buildAwsValue())
}
object ModifyImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyImageAttributeRequest =
      zio.aws.ec2.model.ModifyImageAttributeRequest(
        attribute.map(value => value),
        description.map(value => value.asEditable),
        imageId,
        launchPermission.map(value => value.asEditable),
        operationType.map(value => value),
        productCodes.map(value => value),
        userGroups.map(value => value),
        userIds.map(value => value),
        value.map(value => value),
        organizationArns.map(value => value),
        organizationalUnitArns.map(value => value)
      )
    def attribute: Option[String]
    def description: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def imageId: ImageId
    def launchPermission
        : Option[zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly]
    def operationType: Option[zio.aws.ec2.model.OperationType]
    def productCodes: Option[List[String]]
    def userGroups: Option[List[String]]
    def userIds: Option[List[String]]
    def value: Option[String]
    def organizationArns: Option[List[String]]
    def organizationalUnitArns: Option[List[String]]
    def getAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getLaunchPermission: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchPermission", launchPermission)
    def getOperationType: ZIO[Any, AwsError, zio.aws.ec2.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getProductCodes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getUserGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userGroups", userGroups)
    def getUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getOrganizationArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("organizationArns", organizationArns)
    def getOrganizationalUnitArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("organizationalUnitArns", organizationalUnitArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ) extends zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly {
    override val attribute: Option[String] =
      scala.Option(impl.attribute()).map(value => value: String)
    override val description
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.description())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val launchPermission
        : Option[zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly] =
      scala
        .Option(impl.launchPermission())
        .map(value =>
          zio.aws.ec2.model.LaunchPermissionModifications.wrap(value)
        )
    override val operationType: Option[zio.aws.ec2.model.OperationType] = scala
      .Option(impl.operationType())
      .map(value => zio.aws.ec2.model.OperationType.wrap(value))
    override val productCodes: Option[List[String]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userGroups: Option[List[String]] = scala
      .Option(impl.userGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userIds: Option[List[String]] = scala
      .Option(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val organizationArns: Option[List[String]] = scala
      .Option(impl.organizationArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val organizationalUnitArns: Option[List[String]] = scala
      .Option(impl.organizationalUnitArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ): zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly = new Wrapper(impl)
}
