package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LocalGatewayId, ResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocalGatewayRouteTable(
    localGatewayRouteTableId: Option[String] = None,
    localGatewayRouteTableArn: Option[ResourceArn] = None,
    localGatewayId: Option[LocalGatewayId] = None,
    outpostArn: Option[String] = None,
    ownerId: Option[String] = None,
    state: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable = {
    import LocalGatewayRouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
      .builder()
      .optionallyWith(
        localGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(
        localGatewayId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRouteTable.wrap(buildAwsValue())
}
object LocalGatewayRouteTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRouteTable =
      zio.aws.ec2.model.LocalGatewayRouteTable(
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        localGatewayId.map(value => value),
        outpostArn.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayRouteTableId: Option[String]
    def localGatewayRouteTableArn: Option[ResourceArn]
    def localGatewayId: Option[LocalGatewayId]
    def outpostArn: Option[String]
    def ownerId: Option[String]
    def state: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getLocalGatewayId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ) extends zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly {
    override val localGatewayRouteTableId: Option[String] =
      scala.Option(impl.localGatewayRouteTableId()).map(value => value: String)
    override val localGatewayRouteTableArn: Option[ResourceArn] = scala
      .Option(impl.localGatewayRouteTableArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val localGatewayId: Option[LocalGatewayId] = scala
      .Option(impl.localGatewayId())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable
  ): zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly = new Wrapper(impl)
}
