package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageDiskContainer(
    description: Option[String] = None,
    deviceName: Option[String] = None,
    format: Option[String] = None,
    snapshotId: Option[SnapshotId] = None,
    url: Option[String] = None,
    userBucket: Option[zio.aws.ec2.model.UserBucket] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImageDiskContainer = {
    import ImageDiskContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImageDiskContainer
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImageDiskContainer.ReadOnly =
    zio.aws.ec2.model.ImageDiskContainer.wrap(buildAwsValue())
}
object ImageDiskContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImageDiskContainer =
      zio.aws.ec2.model.ImageDiskContainer(
        description.map(value => value),
        deviceName.map(value => value),
        format.map(value => value),
        snapshotId.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Option[String]
    def deviceName: Option[String]
    def format: Option[String]
    def snapshotId: Option[SnapshotId]
    def url: Option[String]
    def userBucket: Option[zio.aws.ec2.model.UserBucket.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucket.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ) extends zio.aws.ec2.model.ImageDiskContainer.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val deviceName: Option[String] =
      scala.Option(impl.deviceName()).map(value => value: String)
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
    override val userBucket: Option[zio.aws.ec2.model.UserBucket.ReadOnly] =
      scala
        .Option(impl.userBucket())
        .map(value => zio.aws.ec2.model.UserBucket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImageDiskContainer
  ): zio.aws.ec2.model.ImageDiskContainer.ReadOnly = new Wrapper(impl)
}
