package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{DescribeVpcsMaxResults, VpcId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    vpcIds: Option[Iterable[VpcId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeVpcsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest = {
    import DescribeVpcsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            VpcId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => DescribeVpcsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcsRequest.wrap(buildAwsValue())
}
object DescribeVpcsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcsRequest =
      zio.aws.ec2.model.DescribeVpcsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpcIds: Option[List[VpcId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeVpcsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpcIds: ZIO[Any, AwsError, List[VpcId]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeVpcsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest
  ) extends zio.aws.ec2.model.DescribeVpcsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpcIds: Option[List[VpcId]] = scala
      .Option(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeVpcsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.DescribeVpcsMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest
  ): zio.aws.ec2.model.DescribeVpcsRequest.ReadOnly = new Wrapper(impl)
}
