package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupRulesResponse(
    securityGroupRules: Option[Iterable[zio.aws.ec2.model.SecurityGroupRule]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse = {
    import DescribeSecurityGroupRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse
      .builder()
      .optionallyWith(
        securityGroupRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.wrap(buildAwsValue())
}
object DescribeSecurityGroupRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupRulesResponse =
      zio.aws.ec2.model.DescribeSecurityGroupRulesResponse(
        securityGroupRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityGroupRules
        : Option[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]]
    def nextToken: Option[String]
    def getSecurityGroupRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupRule.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroupRules", securityGroupRules)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse
  ) extends zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly {
    override val securityGroupRules
        : Option[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]] = scala
      .Option(impl.securityGroupRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SecurityGroupRule.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse
  ): zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly =
    new Wrapper(impl)
}
