package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkAclsResponse(
    networkAcls: Option[Iterable[zio.aws.ec2.model.NetworkAcl]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse = {
    import DescribeNetworkAclsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse
      .builder()
      .optionallyWith(
        networkAcls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkAcls)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkAclsResponse.wrap(buildAwsValue())
}
object DescribeNetworkAclsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkAclsResponse =
      zio.aws.ec2.model.DescribeNetworkAclsResponse(
        networkAcls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkAcls: Option[List[zio.aws.ec2.model.NetworkAcl.ReadOnly]]
    def nextToken: Option[String]
    def getNetworkAcls
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NetworkAcl.ReadOnly]] =
      AwsError.unwrapOptionField("networkAcls", networkAcls)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse
  ) extends zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly {
    override val networkAcls
        : Option[List[zio.aws.ec2.model.NetworkAcl.ReadOnly]] = scala
      .Option(impl.networkAcls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkAcl.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse
  ): zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly = new Wrapper(impl)
}
