package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayVirtualInterfacesResponse(
    localGatewayVirtualInterfaces: Option[
      Iterable[zio.aws.ec2.model.LocalGatewayVirtualInterface]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse = {
    import DescribeLocalGatewayVirtualInterfacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayVirtualInterfaces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayVirtualInterfacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse =
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse(
        localGatewayVirtualInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGatewayVirtualInterfaces
        : Option[List[zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly]]
    def nextToken: Option[String]
    def getLocalGatewayVirtualInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localGatewayVirtualInterfaces",
      localGatewayVirtualInterfaces
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly {
    override val localGatewayVirtualInterfaces: Option[
      List[zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly]
    ] = scala
      .Option(impl.localGatewayVirtualInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalGatewayVirtualInterface.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly =
    new Wrapper(impl)
}
