package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIamInstanceProfileAssociationsResponse(
    iamInstanceProfileAssociations: Option[
      Iterable[zio.aws.ec2.model.IamInstanceProfileAssociation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse = {
    import DescribeIamInstanceProfileAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
      .builder()
      .optionallyWith(
        iamInstanceProfileAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iamInstanceProfileAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeIamInstanceProfileAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse =
      zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse(
        iamInstanceProfileAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def iamInstanceProfileAssociations
        : Option[List[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getIamInstanceProfileAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "iamInstanceProfileAssociations",
      iamInstanceProfileAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly {
    override val iamInstanceProfileAssociations: Option[
      List[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]
    ] = scala
      .Option(impl.iamInstanceProfileAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse
  ): zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
