package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIpamScopeResponse(
    ipamScope: Option[zio.aws.ec2.model.IpamScope] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse = {
    import CreateIpamScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse
      .builder()
      .optionallyWith(ipamScope.map(value => value.buildAwsValue()))(
        _.ipamScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly =
    zio.aws.ec2.model.CreateIpamScopeResponse.wrap(buildAwsValue())
}
object CreateIpamScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamScopeResponse =
      zio.aws.ec2.model
        .CreateIpamScopeResponse(ipamScope.map(value => value.asEditable))
    def ipamScope: Option[zio.aws.ec2.model.IpamScope.ReadOnly]
    def getIpamScope: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
      AwsError.unwrapOptionField("ipamScope", ipamScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse
  ) extends zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly {
    override val ipamScope: Option[zio.aws.ec2.model.IpamScope.ReadOnly] = scala
      .Option(impl.ipamScope())
      .map(value => zio.aws.ec2.model.IpamScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse
  ): zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly = new Wrapper(impl)
}
