package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConnectionLogOptions(
    enabled: Option[Boolean] = None,
    cloudwatchLogGroup: Option[String] = None,
    cloudwatchLogStream: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConnectionLogOptions = {
    import ConnectionLogOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConnectionLogOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(cloudwatchLogGroup.map(value => value: java.lang.String))(
        _.cloudwatchLogGroup
      )
      .optionallyWith(
        cloudwatchLogStream.map(value => value: java.lang.String)
      )(_.cloudwatchLogStream)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConnectionLogOptions.ReadOnly =
    zio.aws.ec2.model.ConnectionLogOptions.wrap(buildAwsValue())
}
object ConnectionLogOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConnectionLogOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConnectionLogOptions =
      zio.aws.ec2.model.ConnectionLogOptions(
        enabled.map(value => value),
        cloudwatchLogGroup.map(value => value),
        cloudwatchLogStream.map(value => value)
      )
    def enabled: Option[Boolean]
    def cloudwatchLogGroup: Option[String]
    def cloudwatchLogStream: Option[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getCloudwatchLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchLogGroup", cloudwatchLogGroup)
    def getCloudwatchLogStream: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchLogStream", cloudwatchLogStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionLogOptions
  ) extends zio.aws.ec2.model.ConnectionLogOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val cloudwatchLogGroup: Option[String] =
      scala.Option(impl.cloudwatchLogGroup()).map(value => value: String)
    override val cloudwatchLogStream: Option[String] =
      scala.Option(impl.cloudwatchLogStream()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConnectionLogOptions
  ): zio.aws.ec2.model.ConnectionLogOptions.ReadOnly = new Wrapper(impl)
}
