package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationPreference {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.CapacityReservationPreference
}
object CapacityReservationPreference {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationPreference
  ): zio.aws.ec2.model.CapacityReservationPreference = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationPreference {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationPreference =
      software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.ec2.model.CapacityReservationPreference {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationPreference =
      software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.OPEN
  }
  case object none extends zio.aws.ec2.model.CapacityReservationPreference {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationPreference =
      software.amazon.awssdk.services.ec2.model.CapacityReservationPreference.NONE
  }
}
