package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcCidrBlockAssociation(
    associationId: Optional[String] = Optional.Absent,
    cidrBlock: Optional[String] = Optional.Absent,
    cidrBlockState: Optional[zio.aws.ec2.model.VpcCidrBlockState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation = {
    import VpcCidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(cidrBlockState.map(value => value.buildAwsValue()))(
        _.cidrBlockState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly =
    zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(buildAwsValue())
}
object VpcCidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcCidrBlockAssociation =
      zio.aws.ec2.model.VpcCidrBlockAssociation(
        associationId.map(value => value),
        cidrBlock.map(value => value),
        cidrBlockState.map(value => value.asEditable)
      )
    def associationId: Optional[String]
    def cidrBlock: Optional[String]
    def cidrBlockState: Optional[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getCidrBlockState
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] =
      AwsError.unwrapOptionField("cidrBlockState", cidrBlockState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ) extends zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val cidrBlockState
        : Optional[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlockState())
        .map(value => zio.aws.ec2.model.VpcCidrBlockState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ): zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly = new Wrapper(impl)
}
