package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessSseSpecificationRequest(
    customerManagedKeyEnabled: Optional[Boolean] = Optional.Absent,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest = {
    import VerifiedAccessSseSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest
      .builder()
      .optionallyWith(
        customerManagedKeyEnabled.map(value => value: java.lang.Boolean)
      )(_.customerManagedKeyEnabled)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
      .wrap(buildAwsValue())
}
object VerifiedAccessSseSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest =
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest(
        customerManagedKeyEnabled.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def customerManagedKeyEnabled: Optional[Boolean]
    def kmsKeyArn: Optional[KmsKeyArn]
    def getCustomerManagedKeyEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("customerManagedKeyEnabled", customerManagedKeyEnabled)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest
  ) extends zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly {
    override val customerManagedKeyEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerManagedKeyEnabled())
        .map(value => value: Boolean)
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest
  ): zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
