package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait UsageClassType {
  def unwrap: software.amazon.awssdk.services.ec2.model.UsageClassType
}
object UsageClassType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.UsageClassType
  ): zio.aws.ec2.model.UsageClassType = value match {
    case software.amazon.awssdk.services.ec2.model.UsageClassType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.UsageClassType.SPOT =>
      val r = spot
      r
    case software.amazon.awssdk.services.ec2.model.UsageClassType.ON_DEMAND =>
      val r = `on-demand`
      r
    case software.amazon.awssdk.services.ec2.model.UsageClassType.CAPACITY_BLOCK =>
      val r = `capacity-block`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.UsageClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UsageClassType =
      software.amazon.awssdk.services.ec2.model.UsageClassType.UNKNOWN_TO_SDK_VERSION
  }
  case object spot extends zio.aws.ec2.model.UsageClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UsageClassType =
      software.amazon.awssdk.services.ec2.model.UsageClassType.SPOT
  }
  case object `on-demand` extends zio.aws.ec2.model.UsageClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UsageClassType =
      software.amazon.awssdk.services.ec2.model.UsageClassType.ON_DEMAND
  }
  case object `capacity-block` extends zio.aws.ec2.model.UsageClassType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UsageClassType =
      software.amazon.awssdk.services.ec2.model.UsageClassType.CAPACITY_BLOCK
  }
}
