package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPeeringAttachmentOptions(
    dynamicRouting: Optional[zio.aws.ec2.model.DynamicRoutingValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions = {
    import TransitGatewayPeeringAttachmentOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions
      .builder()
      .optionallyWith(dynamicRouting.map(value => value.unwrap))(
        _.dynamicRouting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions
      .wrap(buildAwsValue())
}
object TransitGatewayPeeringAttachmentOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions =
      zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions(
        dynamicRouting.map(value => value)
      )
    def dynamicRouting: Optional[zio.aws.ec2.model.DynamicRoutingValue]
    def getDynamicRouting
        : ZIO[Any, AwsError, zio.aws.ec2.model.DynamicRoutingValue] =
      AwsError.unwrapOptionField("dynamicRouting", dynamicRouting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions
  ) extends zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions.ReadOnly {
    override val dynamicRouting
        : Optional[zio.aws.ec2.model.DynamicRoutingValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamicRouting())
        .map(value => zio.aws.ec2.model.DynamicRoutingValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions
  ): zio.aws.ec2.model.TransitGatewayPeeringAttachmentOptions.ReadOnly =
    new Wrapper(impl)
}
