package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{CoipPoolId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subnet(
    availabilityZone: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    availableIpAddressCount: Optional[Integer] = Optional.Absent,
    cidrBlock: Optional[String] = Optional.Absent,
    defaultForAz: Optional[Boolean] = Optional.Absent,
    enableLniAtDeviceIndex: Optional[Integer] = Optional.Absent,
    mapPublicIpOnLaunch: Optional[Boolean] = Optional.Absent,
    mapCustomerOwnedIpOnLaunch: Optional[Boolean] = Optional.Absent,
    customerOwnedIpv4Pool: Optional[CoipPoolId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.SubnetState] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    assignIpv6AddressOnCreation: Optional[Boolean] = Optional.Absent,
    ipv6CidrBlockAssociationSet: Optional[
      Iterable[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    subnetArn: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    enableDns64: Optional[Boolean] = Optional.Absent,
    ipv6Native: Optional[Boolean] = Optional.Absent,
    privateDnsNameOptionsOnLaunch: Optional[
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Subnet
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(
        availableIpAddressCount.map(value => value: java.lang.Integer)
      )(_.availableIpAddressCount)
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(defaultForAz.map(value => value: java.lang.Boolean))(
        _.defaultForAz
      )
      .optionallyWith(
        enableLniAtDeviceIndex.map(value => value: java.lang.Integer)
      )(_.enableLniAtDeviceIndex)
      .optionallyWith(
        mapPublicIpOnLaunch.map(value => value: java.lang.Boolean)
      )(_.mapPublicIpOnLaunch)
      .optionallyWith(
        mapCustomerOwnedIpOnLaunch.map(value => value: java.lang.Boolean)
      )(_.mapCustomerOwnedIpOnLaunch)
      .optionallyWith(
        customerOwnedIpv4Pool.map(value =>
          CoipPoolId.unwrap(value): java.lang.String
        )
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        assignIpv6AddressOnCreation.map(value => value: java.lang.Boolean)
      )(_.assignIpv6AddressOnCreation)
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(subnetArn.map(value => value: java.lang.String))(
        _.subnetArn
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(enableDns64.map(value => value: java.lang.Boolean))(
        _.enableDns64
      )
      .optionallyWith(ipv6Native.map(value => value: java.lang.Boolean))(
        _.ipv6Native
      )
      .optionallyWith(
        privateDnsNameOptionsOnLaunch.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptionsOnLaunch)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Subnet.ReadOnly =
    zio.aws.ec2.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Subnet = zio.aws.ec2.model.Subnet(
      availabilityZone.map(value => value),
      availabilityZoneId.map(value => value),
      availableIpAddressCount.map(value => value),
      cidrBlock.map(value => value),
      defaultForAz.map(value => value),
      enableLniAtDeviceIndex.map(value => value),
      mapPublicIpOnLaunch.map(value => value),
      mapCustomerOwnedIpOnLaunch.map(value => value),
      customerOwnedIpv4Pool.map(value => value),
      state.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      ownerId.map(value => value),
      assignIpv6AddressOnCreation.map(value => value),
      ipv6CidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      subnetArn.map(value => value),
      outpostArn.map(value => value),
      enableDns64.map(value => value),
      ipv6Native.map(value => value),
      privateDnsNameOptionsOnLaunch.map(value => value.asEditable)
    )
    def availabilityZone: Optional[String]
    def availabilityZoneId: Optional[String]
    def availableIpAddressCount: Optional[Integer]
    def cidrBlock: Optional[String]
    def defaultForAz: Optional[Boolean]
    def enableLniAtDeviceIndex: Optional[Integer]
    def mapPublicIpOnLaunch: Optional[Boolean]
    def mapCustomerOwnedIpOnLaunch: Optional[Boolean]
    def customerOwnedIpv4Pool: Optional[CoipPoolId]
    def state: Optional[zio.aws.ec2.model.SubnetState]
    def subnetId: Optional[String]
    def vpcId: Optional[String]
    def ownerId: Optional[String]
    def assignIpv6AddressOnCreation: Optional[Boolean]
    def ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def subnetArn: Optional[String]
    def outpostArn: Optional[String]
    def enableDns64: Optional[Boolean]
    def ipv6Native: Optional[Boolean]
    def privateDnsNameOptionsOnLaunch
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getAvailableIpAddressCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableIpAddressCount", availableIpAddressCount)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getDefaultForAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultForAz", defaultForAz)
    def getEnableLniAtDeviceIndex: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("enableLniAtDeviceIndex", enableLniAtDeviceIndex)
    def getMapPublicIpOnLaunch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mapPublicIpOnLaunch", mapPublicIpOnLaunch)
    def getMapCustomerOwnedIpOnLaunch: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "mapCustomerOwnedIpOnLaunch",
        mapCustomerOwnedIpOnLaunch
      )
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, CoipPoolId] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SubnetState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getAssignIpv6AddressOnCreation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "assignIpv6AddressOnCreation",
        assignIpv6AddressOnCreation
      )
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSubnetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetArn", subnetArn)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEnableDns64: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableDns64", enableDns64)
    def getIpv6Native: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Native", ipv6Native)
    def getPrivateDnsNameOptionsOnLaunch: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly
    ] = AwsError.unwrapOptionField(
      "privateDnsNameOptionsOnLaunch",
      privateDnsNameOptionsOnLaunch
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Subnet
  ) extends zio.aws.ec2.model.Subnet.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val availableIpAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableIpAddressCount())
        .map(value => value: Integer)
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val defaultForAz: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultForAz())
      .map(value => value: Boolean)
    override val enableLniAtDeviceIndex: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableLniAtDeviceIndex())
        .map(value => value: Integer)
    override val mapPublicIpOnLaunch: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mapPublicIpOnLaunch())
      .map(value => value: Boolean)
    override val mapCustomerOwnedIpOnLaunch: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapCustomerOwnedIpOnLaunch())
        .map(value => value: Boolean)
    override val customerOwnedIpv4Pool: Optional[CoipPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOwnedIpv4Pool())
        .map(value => zio.aws.ec2.model.primitives.CoipPoolId(value))
    override val state: Optional[zio.aws.ec2.model.SubnetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.SubnetState.wrap(value))
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val assignIpv6AddressOnCreation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignIpv6AddressOnCreation())
        .map(value => value: Boolean)
    override val ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation.wrap(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val subnetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetArn())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val enableDns64: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableDns64())
      .map(value => value: Boolean)
    override val ipv6Native: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Native())
      .map(value => value: Boolean)
    override val privateDnsNameOptionsOnLaunch
        : Optional[zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsNameOptionsOnLaunch())
        .map(value =>
          zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Subnet
  ): zio.aws.ec2.model.Subnet.ReadOnly = new Wrapper(impl)
}
