package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SensitiveUserData,
  SubnetId,
  KeyPairName,
  ImageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SpotFleetLaunchSpecification(
    securityGroups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    addressingType: Optional[String] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    kernelId: Optional[String] = Optional.Absent,
    keyName: Optional[KeyPairName] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.SpotFleetMonitoring] =
      Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.SpotPlacement] = Optional.Absent,
    ramdiskId: Optional[String] = Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    userData: Optional[SensitiveUserData] = Optional.Absent,
    weightedCapacity: Optional[Double] = Optional.Absent,
    tagSpecifications: Optional[
      Iterable[zio.aws.ec2.model.SpotFleetTagSpecification]
    ] = Optional.Absent,
    instanceRequirements: Optional[zio.aws.ec2.model.InstanceRequirements] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification = {
    import SpotFleetLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
      .builder()
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(addressingType.map(value => value: java.lang.String))(
        _.addressingType
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        userData.map(value => SensitiveUserData.unwrap(value): java.lang.String)
      )(_.userData)
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.SpotFleetLaunchSpecification.wrap(buildAwsValue())
}
object SpotFleetLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetLaunchSpecification =
      zio.aws.ec2.model.SpotFleetLaunchSpecification(
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addressingType.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        spotPrice.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value),
        weightedCapacity.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceRequirements.map(value => value.asEditable)
      )
    def securityGroups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def addressingType: Optional[String]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def imageId: Optional[ImageId]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def kernelId: Optional[String]
    def keyName: Optional[KeyPairName]
    def monitoring: Optional[zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly]
    def networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def placement: Optional[zio.aws.ec2.model.SpotPlacement.ReadOnly]
    def ramdiskId: Optional[String]
    def spotPrice: Optional[String]
    def subnetId: Optional[SubnetId]
    def userData: Optional[SensitiveUserData]
    def weightedCapacity: Optional[Double]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly]]
    def instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def getSecurityGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAddressingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressingType", addressingType)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, SensitiveUserData] =
      AwsError.unwrapOptionField("userData", userData)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ) extends zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly {
    override val securityGroups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val addressingType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressingType())
      .map(value => value: String)
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => value: String)
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Optional[zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value => zio.aws.ec2.model.SpotFleetMonitoring.wrap(value))
    override val networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val placement: Optional[zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.SpotPlacement.wrap(value))
    override val ramdiskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => value: String)
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Optional[SensitiveUserData] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => zio.aws.ec2.model.primitives.SensitiveUserData(value))
    override val weightedCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.weightedCapacity())
      .map(value => value: Double)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.SpotFleetTagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SpotFleetTagSpecification.wrap(item)
          }.toList
        )
    override val instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRequirements())
        .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification
  ): zio.aws.ec2.model.SpotFleetLaunchSpecification.ReadOnly = new Wrapper(impl)
}
