package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SensitiveUrl
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotDiskContainer(
    description: Optional[String] = Optional.Absent,
    format: Optional[String] = Optional.Absent,
    url: Optional[SensitiveUrl] = Optional.Absent,
    userBucket: Optional[zio.aws.ec2.model.UserBucket] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer = {
    import SnapshotDiskContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(
        url.map(value => SensitiveUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly =
    zio.aws.ec2.model.SnapshotDiskContainer.wrap(buildAwsValue())
}
object SnapshotDiskContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotDiskContainer =
      zio.aws.ec2.model.SnapshotDiskContainer(
        description.map(value => value),
        format.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Optional[String]
    def format: Optional[String]
    def url: Optional[SensitiveUrl]
    def userBucket: Optional[zio.aws.ec2.model.UserBucket.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getUrl: ZIO[Any, AwsError, SensitiveUrl] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucket.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ) extends zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val url: Optional[SensitiveUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.ec2.model.primitives.SensitiveUrl(value))
    override val userBucket: Optional[zio.aws.ec2.model.UserBucket.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userBucket())
        .map(value => zio.aws.ec2.model.UserBucket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer
  ): zio.aws.ec2.model.SnapshotDiskContainer.ReadOnly = new Wrapper(impl)
}
