package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchLocalGatewayRoutesResponse(
    routes: Optional[Iterable[zio.aws.ec2.model.LocalGatewayRoute]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse = {
    import SearchLocalGatewayRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse
      .builder()
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly =
    zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.wrap(buildAwsValue())
}
object SearchLocalGatewayRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SearchLocalGatewayRoutesResponse =
      zio.aws.ec2.model.SearchLocalGatewayRoutesResponse(
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def routes: Optional[List[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly]]
    def nextToken: Optional[String]
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse
  ) extends zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly {
    override val routes
        : Optional[List[zio.aws.ec2.model.LocalGatewayRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LocalGatewayRoute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse
  ): zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly = new Wrapper(
    impl
  )
}
