package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SSEType {
  def unwrap: software.amazon.awssdk.services.ec2.model.SSEType
}
object SSEType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SSEType
  ): zio.aws.ec2.model.SSEType = value match {
    case software.amazon.awssdk.services.ec2.model.SSEType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SSEType.SSE_EBS =>
      val r = `sse-ebs`
      r
    case software.amazon.awssdk.services.ec2.model.SSEType.SSE_KMS =>
      val r = `sse-kms`
      r
    case software.amazon.awssdk.services.ec2.model.SSEType.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SSEType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SSEType =
      software.amazon.awssdk.services.ec2.model.SSEType.UNKNOWN_TO_SDK_VERSION
  }
  case object `sse-ebs` extends zio.aws.ec2.model.SSEType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SSEType =
      software.amazon.awssdk.services.ec2.model.SSEType.SSE_EBS
  }
  case object `sse-kms` extends zio.aws.ec2.model.SSEType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SSEType =
      software.amazon.awssdk.services.ec2.model.SSEType.SSE_KMS
  }
  case object none extends zio.aws.ec2.model.SSEType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SSEType =
      software.amazon.awssdk.services.ec2.model.SSEType.NONE
  }
}
