package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotTierResponse(
    snapshotId: Optional[String] = Optional.Absent,
    restoreStartTime: Optional[MillisecondDateTime] = Optional.Absent,
    restoreDuration: Optional[Integer] = Optional.Absent,
    isPermanentRestore: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse = {
    import RestoreSnapshotTierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        restoreStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.restoreStartTime)
      .optionallyWith(restoreDuration.map(value => value: java.lang.Integer))(
        _.restoreDuration
      )
      .optionallyWith(
        isPermanentRestore.map(value => value: java.lang.Boolean)
      )(_.isPermanentRestore)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotTierResponse.wrap(buildAwsValue())
}
object RestoreSnapshotTierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotTierResponse =
      zio.aws.ec2.model.RestoreSnapshotTierResponse(
        snapshotId.map(value => value),
        restoreStartTime.map(value => value),
        restoreDuration.map(value => value),
        isPermanentRestore.map(value => value)
      )
    def snapshotId: Optional[String]
    def restoreStartTime: Optional[MillisecondDateTime]
    def restoreDuration: Optional[Integer]
    def isPermanentRestore: Optional[Boolean]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getRestoreStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("restoreStartTime", restoreStartTime)
    def getRestoreDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("restoreDuration", restoreDuration)
    def getIsPermanentRestore: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPermanentRestore", isPermanentRestore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ) extends zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val restoreStartTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreStartTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val restoreDuration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreDuration())
      .map(value => value: Integer)
    override val isPermanentRestore: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPermanentRestore())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse
  ): zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly = new Wrapper(impl)
}
