package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreAddressToClassicRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    publicIp: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest = {
    import RestoreAddressToClassicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .publicIp(publicIp: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly =
    zio.aws.ec2.model.RestoreAddressToClassicRequest.wrap(buildAwsValue())
}
object RestoreAddressToClassicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreAddressToClassicRequest =
      zio.aws.ec2.model
        .RestoreAddressToClassicRequest(dryRun.map(value => value), publicIp)
    def dryRun: Optional[Boolean]
    def publicIp: String
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPublicIp: ZIO[Any, Nothing, String] = ZIO.succeed(publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ) extends zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val publicIp: String = impl.publicIp(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ): zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly = new Wrapper(
    impl
  )
}
