package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  ReservedInstancesOfferingId,
  Integer
}
import scala.jdk.CollectionConverters._
final case class PurchaseReservedInstancesOfferingRequest(
    instanceCount: Integer,
    reservedInstancesOfferingId: ReservedInstancesOfferingId,
    dryRun: Optional[Boolean] = Optional.Absent,
    limitPrice: Optional[zio.aws.ec2.model.ReservedInstanceLimitPrice] =
      Optional.Absent,
    purchaseTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest = {
    import PurchaseReservedInstancesOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
      .builder()
      .instanceCount(instanceCount: java.lang.Integer)
      .reservedInstancesOfferingId(
        ReservedInstancesOfferingId.unwrap(
          reservedInstancesOfferingId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(limitPrice.map(value => value.buildAwsValue()))(
        _.limitPrice
      )
      .optionallyWith(
        purchaseTime.map(value => DateTime.unwrap(value): Instant)
      )(_.purchaseTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedInstancesOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest =
      zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest(
        instanceCount,
        reservedInstancesOfferingId,
        dryRun.map(value => value),
        limitPrice.map(value => value.asEditable),
        purchaseTime.map(value => value)
      )
    def instanceCount: Integer
    def reservedInstancesOfferingId: ReservedInstancesOfferingId
    def dryRun: Optional[Boolean]
    def limitPrice
        : Optional[zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly]
    def purchaseTime: Optional[DateTime]
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getReservedInstancesOfferingId
        : ZIO[Any, Nothing, ReservedInstancesOfferingId] =
      ZIO.succeed(reservedInstancesOfferingId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getLimitPrice: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly
    ] = AwsError.unwrapOptionField("limitPrice", limitPrice)
    def getPurchaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("purchaseTime", purchaseTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ) extends zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly {
    override val instanceCount: Integer = impl.instanceCount(): Integer
    override val reservedInstancesOfferingId: ReservedInstancesOfferingId =
      zio.aws.ec2.model.primitives
        .ReservedInstancesOfferingId(impl.reservedInstancesOfferingId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val limitPrice
        : Optional[zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limitPrice())
        .map(value => zio.aws.ec2.model.ReservedInstanceLimitPrice.wrap(value))
    override val purchaseTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.purchaseTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ): zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
