package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, Ipv4PoolEc2Id, IpamPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionPublicIpv4PoolCidrRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamPoolId: IpamPoolId,
    poolId: Ipv4PoolEc2Id,
    netmaskLength: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest = {
    import ProvisionPublicIpv4PoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .poolId(Ipv4PoolEc2Id.unwrap(poolId): java.lang.String)
      .netmaskLength(netmaskLength: java.lang.Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest.wrap(buildAwsValue())
}
object ProvisionPublicIpv4PoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest =
      zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest(
        dryRun.map(value => value),
        ipamPoolId,
        poolId,
        netmaskLength
      )
    def dryRun: Optional[Boolean]
    def ipamPoolId: IpamPoolId
    def poolId: Ipv4PoolEc2Id
    def netmaskLength: Integer
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getPoolId: ZIO[Any, Nothing, Ipv4PoolEc2Id] = ZIO.succeed(poolId)
    def getNetmaskLength: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(netmaskLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest
  ) extends zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val poolId: Ipv4PoolEc2Id =
      zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(impl.poolId())
    override val netmaskLength: Integer = impl.netmaskLength(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest
  ): zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest.ReadOnly =
    new Wrapper(impl)
}
