package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  PlacementGroupId,
  Integer,
  PlacementGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Placement(
    availabilityZone: Optional[String] = Optional.Absent,
    affinity: Optional[String] = Optional.Absent,
    groupName: Optional[PlacementGroupName] = Optional.Absent,
    partitionNumber: Optional[Integer] = Optional.Absent,
    hostId: Optional[String] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    spreadDomain: Optional[String] = Optional.Absent,
    hostResourceGroupArn: Optional[String] = Optional.Absent,
    groupId: Optional[PlacementGroupId] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Placement = {
    import Placement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Placement
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(affinity.map(value => value: java.lang.String))(
        _.affinity
      )
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(partitionNumber.map(value => value: java.lang.Integer))(
        _.partitionNumber
      )
      .optionallyWith(hostId.map(value => value: java.lang.String))(_.hostId)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(spreadDomain.map(value => value: java.lang.String))(
        _.spreadDomain
      )
      .optionallyWith(
        hostResourceGroupArn.map(value => value: java.lang.String)
      )(_.hostResourceGroupArn)
      .optionallyWith(
        groupId.map(value => PlacementGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Placement.ReadOnly =
    zio.aws.ec2.model.Placement.wrap(buildAwsValue())
}
object Placement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Placement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Placement = zio.aws.ec2.model.Placement(
      availabilityZone.map(value => value),
      affinity.map(value => value),
      groupName.map(value => value),
      partitionNumber.map(value => value),
      hostId.map(value => value),
      tenancy.map(value => value),
      spreadDomain.map(value => value),
      hostResourceGroupArn.map(value => value),
      groupId.map(value => value)
    )
    def availabilityZone: Optional[String]
    def affinity: Optional[String]
    def groupName: Optional[PlacementGroupName]
    def partitionNumber: Optional[Integer]
    def hostId: Optional[String]
    def tenancy: Optional[zio.aws.ec2.model.Tenancy]
    def spreadDomain: Optional[String]
    def hostResourceGroupArn: Optional[String]
    def groupId: Optional[PlacementGroupId]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAffinity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("affinity", affinity)
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPartitionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionNumber", partitionNumber)
    def getHostId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostId", hostId)
    def getTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getSpreadDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spreadDomain", spreadDomain)
    def getHostResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostResourceGroupArn", hostResourceGroupArn)
    def getGroupId: ZIO[Any, AwsError, PlacementGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Placement
  ) extends zio.aws.ec2.model.Placement.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val affinity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.affinity())
      .map(value => value: String)
    override val groupName: Optional[PlacementGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
    override val partitionNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionNumber())
      .map(value => value: Integer)
    override val hostId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostId())
      .map(value => value: String)
    override val tenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val spreadDomain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spreadDomain())
      .map(value => value: String)
    override val hostResourceGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostResourceGroupArn())
      .map(value => value: String)
    override val groupId: Optional[PlacementGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Placement
  ): zio.aws.ec2.model.Placement.ReadOnly = new Wrapper(impl)
}
