package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpAddress
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PathFilter(
    sourceAddress: Optional[IpAddress] = Optional.Absent,
    sourcePortRange: Optional[zio.aws.ec2.model.FilterPortRange] =
      Optional.Absent,
    destinationAddress: Optional[IpAddress] = Optional.Absent,
    destinationPortRange: Optional[zio.aws.ec2.model.FilterPortRange] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.PathFilter = {
    import PathFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PathFilter
      .builder()
      .optionallyWith(
        sourceAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.sourceAddress)
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(
        destinationAddress.map(value =>
          IpAddress.unwrap(value): java.lang.String
        )
      )(_.destinationAddress)
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PathFilter.ReadOnly =
    zio.aws.ec2.model.PathFilter.wrap(buildAwsValue())
}
object PathFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PathFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PathFilter = zio.aws.ec2.model.PathFilter(
      sourceAddress.map(value => value),
      sourcePortRange.map(value => value.asEditable),
      destinationAddress.map(value => value),
      destinationPortRange.map(value => value.asEditable)
    )
    def sourceAddress: Optional[IpAddress]
    def sourcePortRange: Optional[zio.aws.ec2.model.FilterPortRange.ReadOnly]
    def destinationAddress: Optional[IpAddress]
    def destinationPortRange
        : Optional[zio.aws.ec2.model.FilterPortRange.ReadOnly]
    def getSourceAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("sourceAddress", sourceAddress)
    def getSourcePortRange
        : ZIO[Any, AwsError, zio.aws.ec2.model.FilterPortRange.ReadOnly] =
      AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getDestinationAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("destinationAddress", destinationAddress)
    def getDestinationPortRange
        : ZIO[Any, AwsError, zio.aws.ec2.model.FilterPortRange.ReadOnly] =
      AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PathFilter
  ) extends zio.aws.ec2.model.PathFilter.ReadOnly {
    override val sourceAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAddress())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val sourcePortRange
        : Optional[zio.aws.ec2.model.FilterPortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePortRange())
        .map(value => zio.aws.ec2.model.FilterPortRange.wrap(value))
    override val destinationAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationAddress())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val destinationPortRange
        : Optional[zio.aws.ec2.model.FilterPortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPortRange())
        .map(value => zio.aws.ec2.model.FilterPortRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PathFilter
  ): zio.aws.ec2.model.PathFilter.ReadOnly = new Wrapper(impl)
}
