package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointPortNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointEniOptions(
    protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      Optional.Absent,
    port: Optional[VerifiedAccessEndpointPortNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions = {
    import ModifyVerifiedAccessEndpointEniOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        port.map(value =>
          VerifiedAccessEndpointPortNumber.unwrap(value): Integer
        )
      )(_.port)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointEniOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions(
        protocol.map(value => value),
        port.map(value => value)
      )
    def protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol]
    def port: Optional[VerifiedAccessEndpointPortNumber]
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, VerifiedAccessEndpointPortNumber] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly {
    override val protocol
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointProtocol.wrap(value)
        )
    override val port: Optional[VerifiedAccessEndpointPortNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.port())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessEndpointPortNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointEniOptions
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointEniOptions.ReadOnly =
    new Wrapper(impl)
}
