package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, SecurityGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifySnapshotAttributeRequest(
    attribute: Optional[zio.aws.ec2.model.SnapshotAttributeName] =
      Optional.Absent,
    createVolumePermission: Optional[
      zio.aws.ec2.model.CreateVolumePermissionModifications
    ] = Optional.Absent,
    groupNames: Optional[Iterable[SecurityGroupName]] = Optional.Absent,
    operationType: Optional[zio.aws.ec2.model.OperationType] = Optional.Absent,
    snapshotId: SnapshotId,
    userIds: Optional[Iterable[String]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest = {
    import ModifySnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        createVolumePermission.map(value => value.buildAwsValue())
      )(_.createVolumePermission)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifySnapshotAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifySnapshotAttributeRequest.wrap(buildAwsValue())
}
object ModifySnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifySnapshotAttributeRequest =
      zio.aws.ec2.model.ModifySnapshotAttributeRequest(
        attribute.map(value => value),
        createVolumePermission.map(value => value.asEditable),
        groupNames.map(value => value),
        operationType.map(value => value),
        snapshotId,
        userIds.map(value => value),
        dryRun.map(value => value)
      )
    def attribute: Optional[zio.aws.ec2.model.SnapshotAttributeName]
    def createVolumePermission: Optional[
      zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly
    ]
    def groupNames: Optional[List[SecurityGroupName]]
    def operationType: Optional[zio.aws.ec2.model.OperationType]
    def snapshotId: SnapshotId
    def userIds: Optional[List[String]]
    def dryRun: Optional[Boolean]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getCreateVolumePermission: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createVolumePermission",
      createVolumePermission
    )
    def getGroupNames: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getOperationType: ZIO[Any, AwsError, zio.aws.ec2.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest
  ) extends zio.aws.ec2.model.ModifySnapshotAttributeRequest.ReadOnly {
    override val attribute: Optional[zio.aws.ec2.model.SnapshotAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.ec2.model.SnapshotAttributeName.wrap(value))
    override val createVolumePermission: Optional[
      zio.aws.ec2.model.CreateVolumePermissionModifications.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createVolumePermission())
      .map(value =>
        zio.aws.ec2.model.CreateVolumePermissionModifications.wrap(value)
      )
    override val groupNames: Optional[List[SecurityGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupName(item)
          }.toList
        )
    override val operationType: Optional[zio.aws.ec2.model.OperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationType())
        .map(value => zio.aws.ec2.model.OperationType.wrap(value))
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val userIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest
  ): zio.aws.ec2.model.ModifySnapshotAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
