package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamScopeRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamScopeId: IpamScopeId,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest = {
    import ModifyIpamScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamScopeRequest.wrap(buildAwsValue())
}
object ModifyIpamScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamScopeRequest =
      zio.aws.ec2.model.ModifyIpamScopeRequest(
        dryRun.map(value => value),
        ipamScopeId,
        description.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def ipamScopeId: IpamScopeId
    def description: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ) extends zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest
  ): zio.aws.ec2.model.ModifyIpamScopeRequest.ReadOnly = new Wrapper(impl)
}
