package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  CapacityReservationFleetId
}
import scala.jdk.CollectionConverters._
final case class ModifyCapacityReservationFleetRequest(
    capacityReservationFleetId: CapacityReservationFleetId,
    totalTargetCapacity: Optional[Integer] = Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    removeEndDate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest = {
    import ModifyCapacityReservationFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
      .builder()
      .capacityReservationFleetId(
        CapacityReservationFleetId.unwrap(
          capacityReservationFleetId
        ): java.lang.String
      )
      .optionallyWith(
        totalTargetCapacity.map(value => value: java.lang.Integer)
      )(_.totalTargetCapacity)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(removeEndDate.map(value => value: java.lang.Boolean))(
        _.removeEndDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly =
    zio.aws.ec2.model.ModifyCapacityReservationFleetRequest
      .wrap(buildAwsValue())
}
object ModifyCapacityReservationFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyCapacityReservationFleetRequest =
      zio.aws.ec2.model.ModifyCapacityReservationFleetRequest(
        capacityReservationFleetId,
        totalTargetCapacity.map(value => value),
        endDate.map(value => value),
        dryRun.map(value => value),
        removeEndDate.map(value => value)
      )
    def capacityReservationFleetId: CapacityReservationFleetId
    def totalTargetCapacity: Optional[Integer]
    def endDate: Optional[MillisecondDateTime]
    def dryRun: Optional[Boolean]
    def removeEndDate: Optional[Boolean]
    def getCapacityReservationFleetId
        : ZIO[Any, Nothing, CapacityReservationFleetId] =
      ZIO.succeed(capacityReservationFleetId)
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getRemoveEndDate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removeEndDate", removeEndDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ) extends zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly {
    override val capacityReservationFleetId: CapacityReservationFleetId =
      zio.aws.ec2.model.primitives
        .CapacityReservationFleetId(impl.capacityReservationFleetId())
    override val totalTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalTargetCapacity())
      .map(value => value: Integer)
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val removeEndDate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.removeEndDate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ): zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly =
    new Wrapper(impl)
}
