package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.LocationType
}
object LocationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocationType
  ): zio.aws.ec2.model.LocationType = value match {
    case software.amazon.awssdk.services.ec2.model.LocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocationType.REGION =>
      val r = region
      r
    case software.amazon.awssdk.services.ec2.model.LocationType.AVAILABILITY_ZONE =>
      val r = `availability-zone`
      r
    case software.amazon.awssdk.services.ec2.model.LocationType.AVAILABILITY_ZONE_ID =>
      val r = `availability-zone-id`
      r
    case software.amazon.awssdk.services.ec2.model.LocationType.OUTPOST =>
      val r = outpost
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocationType =
      software.amazon.awssdk.services.ec2.model.LocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object region extends zio.aws.ec2.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocationType =
      software.amazon.awssdk.services.ec2.model.LocationType.REGION
  }
  case object `availability-zone` extends zio.aws.ec2.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocationType =
      software.amazon.awssdk.services.ec2.model.LocationType.AVAILABILITY_ZONE
  }
  case object `availability-zone-id` extends zio.aws.ec2.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocationType =
      software.amazon.awssdk.services.ec2.model.LocationType.AVAILABILITY_ZONE_ID
  }
  case object outpost extends zio.aws.ec2.model.LocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocationType =
      software.amazon.awssdk.services.ec2.model.LocationType.OUTPOST
  }
}
