package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateInstanceMetadataEndpointState {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState
}
object LaunchTemplateInstanceMetadataEndpointState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState
  ): zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState =
    value match {
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.DISABLED =>
        val r = disabled
        r
      case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.ENABLED =>
        val r = enabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.DISABLED
  }
  case object enabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataEndpointState.ENABLED
  }
}
