package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  InferenceDeviceManufacturerName,
  InferenceDeviceName,
  InferenceDeviceCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InferenceDeviceInfo(
    count: Optional[InferenceDeviceCount] = Optional.Absent,
    name: Optional[InferenceDeviceName] = Optional.Absent,
    manufacturer: Optional[InferenceDeviceManufacturerName] = Optional.Absent,
    memoryInfo: Optional[zio.aws.ec2.model.InferenceDeviceMemoryInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo = {
    import InferenceDeviceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
      .builder()
      .optionallyWith(
        count.map(value => InferenceDeviceCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(
        name.map(value => InferenceDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        manufacturer.map(value =>
          InferenceDeviceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturer)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly =
    zio.aws.ec2.model.InferenceDeviceInfo.wrap(buildAwsValue())
}
object InferenceDeviceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InferenceDeviceInfo =
      zio.aws.ec2.model.InferenceDeviceInfo(
        count.map(value => value),
        name.map(value => value),
        manufacturer.map(value => value),
        memoryInfo.map(value => value.asEditable)
      )
    def count: Optional[InferenceDeviceCount]
    def name: Optional[InferenceDeviceName]
    def manufacturer: Optional[InferenceDeviceManufacturerName]
    def memoryInfo
        : Optional[zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly]
    def getCount: ZIO[Any, AwsError, InferenceDeviceCount] =
      AwsError.unwrapOptionField("count", count)
    def getName: ZIO[Any, AwsError, InferenceDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, InferenceDeviceManufacturerName] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getMemoryInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly
    ] = AwsError.unwrapOptionField("memoryInfo", memoryInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ) extends zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly {
    override val count: Optional[InferenceDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.ec2.model.primitives.InferenceDeviceCount(value))
    override val name: Optional[InferenceDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ec2.model.primitives.InferenceDeviceName(value))
    override val manufacturer: Optional[InferenceDeviceManufacturerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manufacturer())
        .map(value =>
          zio.aws.ec2.model.primitives.InferenceDeviceManufacturerName(value)
        )
    override val memoryInfo
        : Optional[zio.aws.ec2.model.InferenceDeviceMemoryInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryInfo())
        .map(value => zio.aws.ec2.model.InferenceDeviceMemoryInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo
  ): zio.aws.ec2.model.InferenceDeviceInfo.ReadOnly = new Wrapper(impl)
}
