package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportImageRequest(
    architecture: Optional[String] = Optional.Absent,
    clientData: Optional[zio.aws.ec2.model.ClientData] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    diskContainers: Optional[Iterable[zio.aws.ec2.model.ImageDiskContainer]] =
      Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    hypervisor: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    licenseType: Optional[String] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    roleName: Optional[String] = Optional.Absent,
    licenseSpecifications: Optional[
      Iterable[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest]
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    usageOperation: Optional[String] = Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.BootModeValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageRequest = {
    import ImportImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageRequest
      .builder()
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(clientData.map(value => value.buildAwsValue()))(
        _.clientData
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        diskContainers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.diskContainers)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(hypervisor.map(value => value: java.lang.String))(
        _.hypervisor
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(licenseType.map(value => value: java.lang.String))(
        _.licenseType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportImageRequest.ReadOnly =
    zio.aws.ec2.model.ImportImageRequest.wrap(buildAwsValue())
}
object ImportImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageRequest =
      zio.aws.ec2.model.ImportImageRequest(
        architecture.map(value => value),
        clientData.map(value => value.asEditable),
        clientToken.map(value => value),
        description.map(value => value),
        diskContainers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        encrypted.map(value => value),
        hypervisor.map(value => value),
        kmsKeyId.map(value => value),
        licenseType.map(value => value),
        platform.map(value => value),
        roleName.map(value => value),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageOperation.map(value => value),
        bootMode.map(value => value)
      )
    def architecture: Optional[String]
    def clientData: Optional[zio.aws.ec2.model.ClientData.ReadOnly]
    def clientToken: Optional[String]
    def description: Optional[String]
    def diskContainers
        : Optional[List[zio.aws.ec2.model.ImageDiskContainer.ReadOnly]]
    def dryRun: Optional[Boolean]
    def encrypted: Optional[Boolean]
    def hypervisor: Optional[String]
    def kmsKeyId: Optional[KmsKeyId]
    def licenseType: Optional[String]
    def platform: Optional[String]
    def roleName: Optional[String]
    def licenseSpecifications: Optional[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly]
    ]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def usageOperation: Optional[String]
    def bootMode: Optional[zio.aws.ec2.model.BootModeValues]
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getClientData
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientData.ReadOnly] =
      AwsError.unwrapOptionField("clientData", clientData)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskContainers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImageDiskContainer.ReadOnly
    ]] = AwsError.unwrapOptionField("diskContainers", diskContainers)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHypervisor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLicenseType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ) extends zio.aws.ec2.model.ImportImageRequest.ReadOnly {
    override val architecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => value: String)
    override val clientData: Optional[zio.aws.ec2.model.ClientData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientData())
        .map(value => zio.aws.ec2.model.ClientData.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val diskContainers
        : Optional[List[zio.aws.ec2.model.ImageDiskContainer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskContainers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ImageDiskContainer.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val hypervisor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hypervisor())
      .map(value => value: String)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val licenseType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseType())
      .map(value => value: String)
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val roleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => value: String)
    override val licenseSpecifications: Optional[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.wrap(item)
        }.toList
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val usageOperation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageOperation())
      .map(value => value: String)
    override val bootMode: Optional[zio.aws.ec2.model.BootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ): zio.aws.ec2.model.ImportImageRequest.ReadOnly = new Wrapper(impl)
}
