package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait HostnameType {
  def unwrap: software.amazon.awssdk.services.ec2.model.HostnameType
}
object HostnameType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.HostnameType
  ): zio.aws.ec2.model.HostnameType = value match {
    case software.amazon.awssdk.services.ec2.model.HostnameType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.HostnameType.IP_NAME =>
      val r = `ip-name`
      r
    case software.amazon.awssdk.services.ec2.model.HostnameType.RESOURCE_NAME =>
      val r = `resource-name`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.HostnameType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostnameType =
      software.amazon.awssdk.services.ec2.model.HostnameType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ip-name` extends zio.aws.ec2.model.HostnameType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostnameType =
      software.amazon.awssdk.services.ec2.model.HostnameType.IP_NAME
  }
  case object `resource-name` extends zio.aws.ec2.model.HostnameType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.HostnameType =
      software.amazon.awssdk.services.ec2.model.HostnameType.RESOURCE_NAME
  }
}
