package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{NextToken, GVCDMaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetVpnConnectionDeviceTypesRequest(
    maxResults: Optional[GVCDMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest = {
    import GetVpnConnectionDeviceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => GVCDMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly =
    zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.wrap(buildAwsValue())
}
object GetVpnConnectionDeviceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest =
      zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        dryRun.map(value => value)
      )
    def maxResults: Optional[GVCDMaxResults]
    def nextToken: Optional[NextToken]
    def dryRun: Optional[Boolean]
    def getMaxResults: ZIO[Any, AwsError, GVCDMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ) extends zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly {
    override val maxResults: Optional[GVCDMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.GVCDMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
