package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVerifiedAccessGroupPolicyRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest = {
    import GetVerifiedAccessGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly =
    zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.wrap(buildAwsValue())
}
object GetVerifiedAccessGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest =
      zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest(
        verifiedAccessGroupId,
        dryRun.map(value => value)
      )
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def dryRun: Optional[Boolean]
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ) extends zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ): zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
