package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSecurityGroupsForVpcResponse(
    nextToken: Optional[String] = Optional.Absent,
    securityGroupForVpcs: Optional[
      Iterable[zio.aws.ec2.model.SecurityGroupForVpc]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse = {
    import GetSecurityGroupsForVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        securityGroupForVpcs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupForVpcs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSecurityGroupsForVpcResponse.ReadOnly =
    zio.aws.ec2.model.GetSecurityGroupsForVpcResponse.wrap(buildAwsValue())
}
object GetSecurityGroupsForVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSecurityGroupsForVpcResponse =
      zio.aws.ec2.model.GetSecurityGroupsForVpcResponse(
        nextToken.map(value => value),
        securityGroupForVpcs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def securityGroupForVpcs
        : Optional[List[zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecurityGroupForVpcs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly
    ]] =
      AwsError.unwrapOptionField("securityGroupForVpcs", securityGroupForVpcs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse
  ) extends zio.aws.ec2.model.GetSecurityGroupsForVpcResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val securityGroupForVpcs
        : Optional[List[zio.aws.ec2.model.SecurityGroupForVpc.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupForVpcs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SecurityGroupForVpc.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse
  ): zio.aws.ec2.model.GetSecurityGroupsForVpcResponse.ReadOnly = new Wrapper(
    impl
  )
}
