package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  PrefixListMaxResults,
  PrefixListResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListEntriesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    prefixListId: PrefixListResourceId,
    targetVersion: Optional[Long] = Optional.Absent,
    maxResults: Optional[PrefixListMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest = {
    import GetManagedPrefixListEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(targetVersion.map(value => value: java.lang.Long))(
        _.targetVersion
      )
      .optionallyWith(
        maxResults.map(value => PrefixListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.wrap(buildAwsValue())
}
object GetManagedPrefixListEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest =
      zio.aws.ec2.model.GetManagedPrefixListEntriesRequest(
        dryRun.map(value => value),
        prefixListId,
        targetVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def prefixListId: PrefixListResourceId
    def targetVersion: Optional[Long]
    def maxResults: Optional[PrefixListMaxResults]
    def nextToken: Optional[NextToken]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getTargetVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getMaxResults: ZIO[Any, AwsError, PrefixListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ) extends zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val targetVersion: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVersion())
      .map(value => value: Long)
    override val maxResults: Optional[PrefixListMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.PrefixListMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ): zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
