package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpamResourceCidrsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    ipamResourceCidrs: Optional[Iterable[zio.aws.ec2.model.IpamResourceCidr]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse = {
    import GetIpamResourceCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipamResourceCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamResourceCidrs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamResourceCidrsResponse.wrap(buildAwsValue())
}
object GetIpamResourceCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamResourceCidrsResponse =
      zio.aws.ec2.model.GetIpamResourceCidrsResponse(
        nextToken.map(value => value),
        ipamResourceCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def ipamResourceCidrs
        : Optional[List[zio.aws.ec2.model.IpamResourceCidr.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamResourceCidrs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamResourceCidr.ReadOnly
    ]] = AwsError.unwrapOptionField("ipamResourceCidrs", ipamResourceCidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ) extends zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamResourceCidrs
        : Optional[List[zio.aws.ec2.model.IpamResourceCidr.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceCidrs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamResourceCidr.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse
  ): zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly = new Wrapper(impl)
}
