package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  IpamPoolId,
  IpamScopeId,
  NextToken,
  IpamMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetIpamResourceCidrsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[IpamMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    ipamScopeId: IpamScopeId,
    ipamPoolId: Optional[IpamPoolId] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.IpamResourceType] =
      Optional.Absent,
    resourceTag: Optional[zio.aws.ec2.model.RequestIpamResourceTag] =
      Optional.Absent,
    resourceOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest = {
    import GetIpamResourceCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => IpamMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceTag.map(value => value.buildAwsValue()))(
        _.resourceTag
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetIpamResourceCidrsRequest.wrap(buildAwsValue())
}
object GetIpamResourceCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamResourceCidrsRequest =
      zio.aws.ec2.model.GetIpamResourceCidrsRequest(
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ipamScopeId,
        ipamPoolId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceTag.map(value => value.asEditable),
        resourceOwner.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[IpamMaxResults]
    def nextToken: Optional[NextToken]
    def ipamScopeId: IpamScopeId
    def ipamPoolId: Optional[IpamPoolId]
    def resourceId: Optional[String]
    def resourceType: Optional[zio.aws.ec2.model.IpamResourceType]
    def resourceTag: Optional[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]
    def resourceOwner: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, IpamMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTag: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ] = AwsError.unwrapOptionField("resourceTag", resourceTag)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ) extends zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[IpamMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.IpamMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val ipamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType: Optional[zio.aws.ec2.model.IpamResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ec2.model.IpamResourceType.wrap(value))
    override val resourceTag
        : Optional[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTag())
        .map(value => zio.aws.ec2.model.RequestIpamResourceTag.wrap(value))
    override val resourceOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest
  ): zio.aws.ec2.model.GetIpamResourceCidrsRequest.ReadOnly = new Wrapper(impl)
}
